# Legal Compliance Framework (KYC / AML / Data Protection)

## 1. KYC system design

- **Optional identity verification level**: Email verification mandatory before earning; additional KYC optional unless required for higher limits.
- **Tier-based withdrawal limits**: e.g. basic (email only): lower limit; verified (ID): higher limit. Enforce server-side.
- **Government ID upload**: Secure upload endpoint; store in encrypted blob storage (e.g. S3 with KMS); store only reference and hash in DB (kyc_records.document_ref).
- **Manual review workflow**: KYC submissions go to admin review queue; status: pending → approved | rejected; store reviewed_at, reviewed_by.
- **KYC status flags**: Store on user or kyc_records (tier, status); use in withdrawal and risk logic.

## 2. AML monitoring

- **Suspicious transaction monitoring**: As per FRAUD_PREVENTION.md (velocity, structuring, spike detection).
- **Rapid withdrawal detection**: Flag and log; optional delay or manual review.
- **Structuring detection**: Many small withdrawals to stay under threshold; flag and add to risk score.
- **Risk score thresholds**: Configurable; trigger review or suspension.
- **SAR logging**: When a decision is made to file or consider a SAR, log in a dedicated table or audit_logs with restricted access.
- **Admin AML review panel**: Separate view of flagged users/withdrawals and fraud_logs; actions logged.

## 3. Data protection compliance (GDPR-style)

- **User data access request flow**: Authenticated endpoint or process for user to request export of their data (profile, tasks, earnings, wallets, KYC refs); generate and deliver in secure way.
- **Account deletion flow**: Soft-delete or anonymize user and PII; retain only what’s required by law (e.g. audit logs, transaction records) with strict access control.
- **Data retention policy**: Define retention for logs, KYC docs, and transactional data; automate deletion or archival.
- **Encrypted storage at rest**: DB encryption (TDE); encrypted object storage for documents and backups.
- **Encrypted transmission**: TLS 1.3 only; no sensitive data in query params or client-side storage.
- **Audit logging of admin actions**: All admin access to PII and financial data logged (who, when, what).

## 4. Terms and compliance pages

- **Privacy Policy**: Data collected, earnings structure (no CPC in frontend), fraud monitoring, wallet encryption, logging, user rights, contact. Implemented: legal/privacy-policy.html.
- **Terms of Service**: Earnings formula, no guaranteed earnings, user obligations, fraud/abuse, wallets/withdrawals, termination. Implemented: legal/terms-of-service.html.
- **Risk Disclosure**: Earnings not guaranteed, withdrawal and compliance risks, technical/operational risks. Implemented: legal/risk-disclosure.html.
- **AML Policy**: Monitoring, risk thresholds, withdrawal/velocity, cooperation. Implemented: legal/aml-policy.html.
- **KYC Policy**: Verification levels, document handling, manual review, data protection. Implemented: legal/kyc-policy.html.

All pages clearly explain admin-controlled profit %, server-side calculations, fraud monitoring, wallet encryption, and that no guaranteed earnings are offered.
