# Backend Architecture

## Overview

The frontend is static HTML + inline CSS + vanilla JS. All business logic, financial calculations, and security enforcement live in the backend. The frontend never receives CPC values, profit percentage for calculation, or the ability to modify balances.

## API Contract (Backend-Ready)

### Authentication
- `POST /api/auth/signup` — Register (unique email, hash password server-side).
- `POST /api/auth/login` — Login; set HTTP-only secure session cookie.
- `POST /api/auth/verify` — Email verification (token in body).
- `GET/POST /api/auth/resend-verification` — Resend verification email.
- `POST /api/auth/logout` — Invalidate session.

Sessions: server-side session store (e.g. Redis), secure cookie, same-site, HTTPS only. No tokens stored in localStorage or exposed to JS for financial actions.

### User (authenticated)
- `GET /api/user/balance` — Returns `{ balance: number }` (read-only; server-controlled).
- `GET /api/user/profile` — Returns `{ email, verified }`.
- `GET /api/user/wallets` — Returns `{ binance?, okx? }` (masked if needed).
- `POST /api/user/wallets` — Body `{ provider: "binance"|"okx", address: string }`.
- `GET /api/user/earnings-history` — Returns `{ earnings: [{ date, task_title, amount }] }`.
- `GET /api/tasks/list` — Returns `{ tasks: [{ id, title, description, duration_seconds, earnings_display, completed }] }`. `earnings_display` is server-computed reward only; no CPC.
- `POST /api/tasks/complete` — Body `{ task_id }`. Idempotent; atomic credit; returns new balance or error.
- `GET /api/withdrawals/history` — Returns `{ withdrawals: [{ created_at, amount, status }] }`.
- `POST /api/withdrawals/request` — Body `{ amount, provider }`. Min $10 enforced server-side.

### Admin (admin role required)
- `GET /api/admin/summary` — Counts for dashboard.
- `GET /api/admin/tasks` — List tasks (no CPC in response if frontend must not show it; CPC only in server UI or internal APIs).
- `POST /api/admin/tasks` — Create task (body: title, description, duration_seconds, video_url optional YouTube link; CPC set server-side from config/DB, not from client).
- `DELETE /api/admin/tasks/:id` — Delete task.
- `POST /api/admin/tasks/:id/toggle` — Activate/deactivate.
- `GET /api/admin/withdrawals` — List withdrawals.
- `POST /api/admin/withdrawals/:id/approve` — Approve (then queue for Binance/OKX).
- `POST /api/admin/withdrawals/:id/reject` — Reject.
- `GET /api/admin/settings` — Returns `{ profit_percentage }` (read-only display).
- `POST /api/admin/settings` — Body `{ profit_percentage }` (1–100); applied to future earnings only.
- `GET /api/admin/analytics` — Query params `from`, `to`. Returns aggregated metrics and chart data (no raw CPC).

## Task completion (server)

1. Validate session and email_verified.
2. Check user has not already completed this task (unique user_id, task_id).
3. Rate limiting and fraud checks (IP, device, velocity).
4. In transaction: read task CPC and admin profit_percentage; compute reward_cents = (profit_pct/100) * cpc_cents; insert user_task_completion; update user balance_cents; commit.
5. Log to audit_logs and fraud_logs as needed.
6. Return success and updated balance; frontend never computes reward.

## Security

- All financial state (balance, rewards, CPC, profit %) is authoritative on the server.
- Frontend treats balance and earnings as read-only.
- Strict role separation: user vs admin; admin APIs check role server-side.
- Financial logs (audit_logs, fraud_logs) are append-only in practice; no frontend write.
- Assume adversarial client: no trust in frontend for amounts or eligibility.
